<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Controllers;

use Pipedrive\APIException;
use Pipedrive\APIHelper;
use Pipedrive\Configuration;
use Pipedrive\Models;
use Pipedrive\Exceptions;
use Pipedrive\Utils\DateTimeHelper;
use Pipedrive\Http\HttpRequest;
use Pipedrive\Http\HttpResponse;
use Pipedrive\Http\HttpMethod;
use Pipedrive\Http\HttpContext;
use Pipedrive\OAuthManager;
use Pipedrive\Servers;
use Pipedrive\Utils\CamelCaseHelper;
use Unirest\Request;

/**
 * @todo Add a general description for this controller.
 */
class GoalsController extends BaseController
{
    /**
     * @var GoalsController The reference to *Singleton* instance of this class
     */
    private static $instance;

    /**
     * Returns the *Singleton* instance of this class.
     * @return GoalsController The *Singleton* instance.
     */
    public static function getInstance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    /**
     * Adds a new goal.
     *
     * @param object $body (optional) TODO: type description here
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function addANewGoal(
        $body = null
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/goals';

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'content-type'  => 'application/json; charset=utf-8',
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //json encode body
        $_bodyJson = Request\Body::Json($body);

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::POST, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::post($_queryUrl, $_headers, $_bodyJson);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Returns data about goals based on criteria. For searching, append `{searchField}={searchValue}` to
     * the URL, where `searchField` can be any one of the lowest-level fields in dot-notation (e.g. `type.
     * params.pipeline_id`; `title`). `searchValue` should be the value you are looking for on that field.
     * Additionally, `is_active=<true|false>` can be provided to search for only active/inactive goals.
     * When providing `period.start`, `period.end` must also be provided and vice versa.
     *
     * @param  array  $options    Array with all options for search
     * @param string   $options['typeName']                         (optional) Type of the goal. If provided,
     *                                                              everyone's goals will be returned.
     * @param string   $options['title']                            (optional) Title of the goal.
     * @param bool     $options['isActive']                         (optional) Whether goal is active or not.
     * @param integer  $options['assigneeId']                       (optional) ID of the user who's goal to fetch. When
     *                                                              omitted, only your goals will be returned.
     * @param string   $options['assigneeType']                     (optional) Type of the goal's assignee. If provided,
     *                                                              everyone's goals will be returned.
     * @param double   $options['expectedOutcomeTarget']            (optional) Numeric value of the outcome. If
     *                                                              provided, everyone's goals will be returned.
     * @param string   $options['expectedOutcomeTrackingMetric']    (optional) Tracking metric of the expected outcome
     *                                                              of the goal. If provided, everyone's goals will be
     *                                                              returned.
     * @param integer  $options['expectedOutcomeCurrencyId']        (optional) Numeric ID of the goal's currency. Only
     *                                                              applicable to goals with `expected_outcome.
     *                                                              tracking_metric` with value `sum`. If provided,
     *                                                              everyone's goals will be returned.
     * @param integer  $options['typeParamsPipelineId']             (optional) ID of the pipeline or `null` for all
     *                                                              pipelines. If provided, everyone's goals will be
     *                                                              returned.
     * @param integer  $options['typeParamsStageId']                (optional) ID of the stage. Applicable to only
     *                                                              `deals_progressed` type of goals. If provided,
     *                                                              everyone's goals will be returned.
     * @param integer  $options['typeParamsActivityTypeId']         (optional) ID of the activity type. Applicable to
     *                                                              only `activities_completed` or `activities_added`
     *                                                              types of goals. If provided, everyone's goals will
     *                                                              be returned.
     * @param DateTime $options['periodStart']                      (optional) Start date of the period for which to
     *                                                              find goals. Date in format of YYYY-MM-DD. When
     *                                                              `period.start` is provided, `period.end` must be
     *                                                              provided too.
     * @param DateTime $options['periodEnd']                        (optional) End date of the period for which to find
     *                                                              goals. Date in format of YYYY-MM-DD.
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function findGoals(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/goals/find';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'type.name'                        => $this->val($options, 'typeName'),
            'title'                            => $this->val($options, 'title'),
            'is_active'                        => $this->val($options, 'isActive', true),
            'assignee.id'                      => $this->val($options, 'assigneeId'),
            'assignee.type'                    => $this->val($options, 'assigneeType'),
            'expected_outcome.target'          => $this->val($options, 'expectedOutcomeTarget'),
            'expected_outcome.tracking_metric' => $this->val($options, 'expectedOutcomeTrackingMetric'),
            'expected_outcome.currency_id'     => $this->val($options, 'expectedOutcomeCurrencyId'),
            'type.params.pipeline_id'          => $this->val($options, 'typeParamsPipelineId'),
            'type.params.stage_id'             => $this->val($options, 'typeParamsStageId'),
            'type.params.activity_type_id'     => $this->val($options, 'typeParamsActivityTypeId'),
            'period.start'                     => DateTimeHelper::toSimpleDate($this->val($options, 'periodStart')),
            'period.end'                       => DateTimeHelper::toSimpleDate($this->val($options, 'periodEnd')),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'                     => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Updates existing goal.
     *
     * @param  array  $options    Array with all options for search
     * @param string $options['id']               ID of the goal to be updated.
     * @param string $options['title']            (optional) Title of the goal.
     * @param object $options['assignee']         (optional) Who is this goal assigned to. It requires the following
     *                                            JSON structure: { "id": "1", "type": "person" }. `type` can be either
     *                                            `person`, `company` or `team`. ID of the assignee person, company or
     *                                            team.
     * @param object $options['type']             (optional) Type of the goal. It requires the following JSON structure:
     *                                            { "name": "deals_started", "params": { "pipeline_id": 1 } }. Type
     *                                            can be one of: `deals_won`,`deals_progressed`,`activities_completed`,
     *                                            `activities_added` or `deals_started`. `params` can include
     *                                            `pipeline_id`, `stage_id` or `activity_type_id`. `stage_id` is
     *                                            related to only `deals_progressed` type of goals and
     *                                            `activity_type_id` to `activities_completed` or `activities_added`
     *                                            types of goals. To track goal in all pipelines set `pipeline_id` as
     *                                            `null`.
     * @param object $options['expectedOutcome']  (optional) Expected outcome of the goal. Expected outcome can be
     *                                            tracked either by `quantity` or by `sum`. It requires the following
     *                                            JSON structure: { "target": "50", "tracking_metric": "quantity" } or
     *                                            { "target": "50", "tracking_metric": "sum", "currency_id": 1 }.
     *                                            `currency_id` should only be added to `sum` type of goals.
     * @param object $options['duration']         (optional) Date when the goal starts and ends. It requires the
     *                                            following JSON structure: { "start": "2019-01-01", "end": "2022-12-
     *                                            31" }. Date in format of YYYY-MM-DD.
     * @param string $options['interval']         (optional) Date when the goal starts and ends. It requires the
     *                                            following JSON structure: { "start": "2019-01-01", "end": "2022-12-
     *                                            31" }. Date in format of YYYY-MM-DD.
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function updateExistingGoal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/goals/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'               => $this->val($options, 'id'),
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'     => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //prepare parameters
        $_parameters = array (
            'title'            => $this->val($options, 'title'),
            'assignee'       => $this->val($options, 'assignee'),
            'type'           => $this->val($options, 'type'),
            'expected_outcome' => $this->val($options, 'expectedOutcome'),
            'duration'       => $this->val($options, 'duration'),
            'interval'       => APIHelper::prepareFormFields($this->val($options, 'interval'))
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::PUT, $_headers, $_queryUrl, $_parameters);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::put($_queryUrl, $_headers, Request\Body::Form($_parameters));

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Marks goal as deleted.
     *
     * @param string $id ID of the goal to be deleted.
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function deleteExistingGoal(
        $id
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/goals/{id}';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id' => $id,
            ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::DELETE, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::delete($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Gets progress of a goal for specified period.
     *
     * @param  array  $options    Array with all options for search
     * @param string   $options['id']           ID of the goal that the results are looked for.
     * @param DateTime $options['periodStart']  Start date of the period for which to find progress of a goal. Date in
     *                                          format of YYYY-MM-DD.
     * @param DateTime $options['periodEnd']    End date of the period for which to find progress of a goal. Date in
     *                                          format of YYYY-MM-DD.
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function getResultOfAGoal(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/goals/{id}/results';

        //process optional query parameters
        $_queryBuilder = APIHelper::appendUrlWithTemplateParameters($_queryBuilder, array (
            'id'           => $this->val($options, 'id'),
            ));

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'period.start' => DateTimeHelper::toSimpleDate($this->val($options, 'periodStart')),
            'period.end'   => DateTimeHelper::toSimpleDate($this->val($options, 'periodEnd')),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }


    /**
    * Array access utility method
     * @param  array          $arr         Array of values to read from
     * @param  string         $key         Key to get the value from the array
     * @param  mixed|null     $default     Default value to use if the key was not found
     * @return mixed
     */
    private function val($arr, $key, $default = null)
    {
        if (isset($arr[$key])) {
            return is_bool($arr[$key]) ? var_export($arr[$key], true) : $arr[$key];
        }
        return $default;
    }
}
