<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Controllers;

use Pipedrive\APIException;
use Pipedrive\APIHelper;
use Pipedrive\Configuration;
use Pipedrive\Models;
use Pipedrive\Exceptions;
use Pipedrive\Http\HttpRequest;
use Pipedrive\Http\HttpResponse;
use Pipedrive\Http\HttpMethod;
use Pipedrive\Http\HttpContext;
use Pipedrive\OAuthManager;
use Pipedrive\Servers;
use Pipedrive\Utils\CamelCaseHelper;
use Unirest\Request;

/**
 * @todo Add a general description for this controller.
 */
class ItemSearchController extends BaseController
{
    /**
     * @var ItemSearchController The reference to *Singleton* instance of this class
     */
    private static $instance;

    /**
     * Returns the *Singleton* instance of this class.
     * @return ItemSearchController The *Singleton* instance.
     */
    public static function getInstance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }
        
        return static::$instance;
    }

    /**
     * Performs a search from your choice of item types and fields.
     *
     * @param  array  $options    Array with all options for search
     * @param string  $options['term']        The search term to look for. Minimum 2 characters (or 1 if using exact_match)
     * @param string  $options['itemTypes']   (optional) A comma-separated string array. The type of items to perform the search from. Defaults to all.
     * @param string  $options['fields']      (optional) A comma-separated string array. The fields to perform the search from. Defaults to all.
     * @param bool    $options['searchForRelatedItems']      (optional) When enabled, the response will include up to 100 newest related Leads and 100 newest related Deals for each found Person and Organization and up to 100 newest related Persons for each found Organization.
     * @param bool    $options['exactMatch']  (optional) When enabled, only full exact matches against the given term are returned. It is not case sensitive.
     * @param string  $options['includeFields']  (optional) A comma-separated string array. Supports including optional fields in the results which are not provided by default.
     *
     * @param integer $options['start']       (optional) Pagination start. Note that the pagination is based on main results and does not include related items when using search_for_related_items parameter.
     * @param integer $options['limit']       (optional) Items shown per page
     *
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function performASearchFromMultipleItemTypes(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/itemSearch';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'term'        => $this->val($options, 'term'),
            'item_types'   => $this->val($options, 'itemTypes'),
            'fields'   => $this->val($options, 'fields'),
            'search_for_related_items'   => $this->val($options, 'searchForRelatedItems'),
            'exact_match' => $this->val($options, 'exactMatch'),
            'include_fields'   => $this->val($options, 'includeFields'),
            'start'       => $this->val($options, 'start', 0),
            'limit'       => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
     * Performs a search from the values of a specific field. Results can either be the distinct values of the field (useful for searching autocomplete field values), or the IDs of actual items (Deals, Persons, Organizations or Products).
     *
     * @param  array  $options    Array with all options for search
     * @param string  $options['term']        The search term to look for. Minimum 2 characters (or 1 if using exact_match).
     * @param string  $options['fieldType']   The type of the field to perform the search from
     * @param string  $options['fieldKey']    The key of the field to search from. The field key can be obtained by fetching the list of the fields using any of the fields' API GET methods (dealFields, personFields, etc.).
     * @param bool    $options['exactMatch']  (optional) When enabled, only full exact matches against the given term are returned. The search is case sensitive
     * @param bool    $options['returnItemIds']  (optional) Whether to return the IDs of the matching items or not. When not set or set to 0 or false, only distinct values of the searched field are returned. When set to 1 or true, the ID of each found item is returned.
     * @param integer $options['start']       (optional) Pagination start
     * @param integer $options['limit']       (optional) Items shown per page
     *
     * @return void response from the API call
     * @throws APIException Thrown if API call fails
     */
    public function performASearchUsingASpecificFieldFromAnItemType(
        $options
    ) {
        //check or get oauth token
        OAuthManager::getInstance()->checkAuthorization();

        //prepare query string for API call
        $_queryBuilder = '/itemSearch/field';

        //process optional query parameters
        APIHelper::appendUrlWithQueryParameters($_queryBuilder, array (
            'term'        => $this->val($options, 'term'),
            'field_type'  => $this->val($options, 'fieldType'),
            'exact_match' => $this->val($options, 'exactMatch'),
            'field_key'   => $this->val($options, 'fieldKey'),
            'return_item_ids'   => $this->val($options, 'returnItemIds'),
            'start'       => $this->val($options, 'start', 0),
            'limit'       => $this->val($options, 'limit'),
        ));

        //validate and preprocess url
        $_queryUrl = APIHelper::cleanUrl(Configuration::getBaseUri() . $_queryBuilder);

        //prepare headers
        $_headers = array (
            'user-agent'    => BaseController::USER_AGENT,
            'Authorization' => sprintf('Bearer %1$s', Configuration::$oAuthToken->accessToken)
        );

        //call on-before Http callback
        $_httpRequest = new HttpRequest(HttpMethod::GET, $_headers, $_queryUrl);
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnBeforeRequest($_httpRequest);
        }

        //and invoke the API call request to fetch the response
        $response = Request::get($_queryUrl, $_headers);

        $_httpResponse = new HttpResponse($response->code, $response->headers, $response->raw_body);
        $_httpContext = new HttpContext($_httpRequest, $_httpResponse);

        //call on-after Http callback
        if ($this->getHttpCallBack() != null) {
            $this->getHttpCallBack()->callOnAfterRequest($_httpContext);
        }

        //handle errors defined at the API level
        $this->validateResponse($_httpResponse, $_httpContext);

        return CamelCaseHelper::keysToCamelCase($response->body);
    }

    /**
    * Array access utility method
     * @param  array          $arr         Array of values to read from
     * @param  string         $key         Key to get the value from the array
     * @param  mixed|null     $default     Default value to use if the key was not found
     * @return mixed
     */
    private function val($arr, $key, $default = null)
    {
        if (isset($arr[$key])) {
            return is_bool($arr[$key]) ? var_export($arr[$key], true) : $arr[$key];
        }
        return $default;
    }
}
