<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Models;

use JsonSerializable;

/**
 *The summary of Deals
 */
class Data24 implements JsonSerializable
{
    /**
     * The total values of the Deals grouped by Deal currency
     * @maps values_total
     * @var \Pipedrive\Models\ValuesTotal|null $valuesTotal public property
     */
    public $valuesTotal;

    /**
     * The total weighted values of the Deals grouped by Deal currency. The weighted value is calculated as
     * probability times Deal value.
     * @maps weighted_values_total
     * @var \Pipedrive\Models\WeightedValuesTotal|null $weightedValuesTotal public property
     */
    public $weightedValuesTotal;

    /**
     * The total number of Deals
     * @maps total_count
     * @var integer|null $totalCount public property
     */
    public $totalCount;

    /**
     * The total value of Deals converted into the company default currency
     * @maps total_currency_converted_value
     * @var double|null $totalCurrencyConvertedValue public property
     */
    public $totalCurrencyConvertedValue;

    /**
     * The total weighted value of Deals converted into the company default currency
     * @maps total_weighted_currency_converted_value
     * @var double|null $totalWeightedCurrencyConvertedValue public property
     */
    public $totalWeightedCurrencyConvertedValue;

    /**
     * The total converted value of Deals formatted with the company default currency. E.g. US$5,100.96
     * @maps total_currency_converted_value_formatted
     * @var string|null $totalCurrencyConvertedValueFormatted public property
     */
    public $totalCurrencyConvertedValueFormatted;

    /**
     * The total weighted value of Deals formatted with the company default currency. E.g. US$5,100.96
     * @maps total_weighted_currency_converted_value_formatted
     * @var string|null $totalWeightedCurrencyConvertedValueFormatted public property
     */
    public $totalWeightedCurrencyConvertedValueFormatted;

    /**
     * Constructor to set initial or default values of member properties
     * @param ValuesTotal         $valuesTotal                                  Initialization value for $this-
     *                                                                            >valuesTotal
     * @param WeightedValuesTotal $weightedValuesTotal                          Initialization value for $this-
     *                                                                            >weightedValuesTotal
     * @param integer             $totalCount                                   Initialization value for $this-
     *                                                                            >totalCount
     * @param double              $totalCurrencyConvertedValue                  Initialization value for $this-
     *                                                                            >totalCurrencyConvertedValue
     * @param double              $totalWeightedCurrencyConvertedValue          Initialization value for $this-
     *                                                                            >totalWeightedCurrencyConvertedValue
     * @param string              $totalCurrencyConvertedValueFormatted         Initialization value for $this-
     *                                                                            >totalCurrencyConvertedValueFormatted
     * @param string              $totalWeightedCurrencyConvertedValueFormatted Initialization value for $this-
     *                                                                            >totalWeightedCurrencyConvertedValueFo
     *                                                                            rmatted
     */
    public function __construct()
    {
        if (7 == func_num_args()) {
            $this->valuesTotal                                  = func_get_arg(0);
            $this->weightedValuesTotal                          = func_get_arg(1);
            $this->totalCount                                   = func_get_arg(2);
            $this->totalCurrencyConvertedValue                  = func_get_arg(3);
            $this->totalWeightedCurrencyConvertedValue          = func_get_arg(4);
            $this->totalCurrencyConvertedValueFormatted         = func_get_arg(5);
            $this->totalWeightedCurrencyConvertedValueFormatted = func_get_arg(6);
        }
    }


    /**
     * Encode this object to JSON
     */
    public function jsonSerialize()
    {
        $json = array();
        $json['values_total']                                      = $this->valuesTotal;
        $json['weighted_values_total']                             = $this->weightedValuesTotal;
        $json['total_count']                                       = $this->totalCount;
        $json['total_currency_converted_value']                    = $this->totalCurrencyConvertedValue;
        $json['total_weighted_currency_converted_value']           = $this->totalWeightedCurrencyConvertedValue;
        $json['total_currency_converted_value_formatted']          = $this->totalCurrencyConvertedValueFormatted;
        $json['total_weighted_currency_converted_value_formatted'] = $this->totalWeightedCurrencyConvertedValueFormatted;

        return $json;
    }
}
