<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Tests;

use Pipedrive\APIException;
use Pipedrive\Exceptions;
use Pipedrive\APIHelper;
use Pipedrive\Models;

class ProductsControllerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \Pipedrive\Controllers\ProductsController Controller instance
     */
    protected static $controller;

    /**
     * @var HttpCallBackCatcher Callback
     */
    protected $httpResponse;

    /**
     * Setup test class
     */
    public static function setUpBeforeClass()
    {
        $client = new \Pipedrive\Client();
        self::$controller = $client->getProducts();
    }

    /**
     * Setup test
     */
    protected function setUp()
    {
        $this->httpResponse = new HttpCallBackCatcher();
    }

    /**
     * Returns data about all products.
     */
    public function testTestGetAllProducts()
    {
        // Parameters for the API call
        $input = array();
        $input['userId'] = null;
        $input['filterId'] = null;
        $input['firstChar'] = null;
        $input['start'] = 0;
        $input['limit'] = null;

        // Set callback and perform API call
        $result = null;
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
            $result = self::$controller->getAllProducts($input);
        } catch (APIException $e) {
        }

        // Test response code
        $this->assertEquals(
            200,
            $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200"
        );

        // Test headers
        $headers = [];
        $headers['Content-Type'] = 'application/json' ;

        $this->assertTrue(
            TestHelper::areHeadersProperSubsetOf($headers, $this->httpResponse->getResponse()->getHeaders(), true),
            "Headers do not match"
        );

        // Test whether the captured response is as we expected
        $this->assertNotNull($result, "Result does not exist");

        $this->assertTrue(
            TestHelper::isJsonObjectProperSubsetOf(
                "{\"success\":true,\"data\":[{\"id\":1,\"name\":\"Mechanical Pencil\",\"code\":\"MPENCIL\",\"descript" .
                "ion\":null,\"unit\":null,\"tax\":0,\"category\":null,\"active_flag\":true,\"selectable\":true,\"firs" .
                "t_char\":\"m\",\"visible_to\":\"3\",\"owner_id\":{\"id\":10100010,\"name\":\"Test User\",\"email\":" .
                "\"example@test.com\",\"has_pic\":true,\"pic_hash\":\"5df5332929fab76702207f38b29a5d88\",\"active_fla" .
                "g\":true,\"value\":10100010},\"files_count\":null,\"followers_count\":0,\"add_time\":\"2019-12-19 11" .
                ":36:49\",\"update_time\":\"2019-12-19 11:36:49\",\"prices\":[{\"id\":1,\"product_id\":1,\"price\":5," .
                "\"currency\":\"EUR\",\"cost\":2,\"overhead_cost\":null}]}],\"additional_data\":{},\"related_objects" .
                "\":null,\"user\":{\"10100010\":{\"id\":10100010,\"name\":\"Test User\",\"email\":\"example@test.com" .
                "\",\"has_pic\":true,\"pic_hash\":\"5df5332929fab76702207f38b29a5d88\",\"active_flag\":true}}}",
                $this->httpResponse->getResponse()->getRawBody(),
                false,
                true,
                false
            ),
            "Response body does not match in keys"
        );
    }

    /**
     * Adds a new product to the products inventory. For more information on how to add a product, see <a href="https://pipedrive.readme.io/docs/adding-a-product" target="_blank" rel="noopener noreferrer">this tutorial</a>.
     */
    public function testTestAddAProduct()
    {
        // Parameters for the API call
        $body = null;

        // Set callback and perform API call
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
            self::$controller->addAProduct($body);
        } catch (APIException $e) {
        }

        // Test response code
        $this->assertEquals(
            200,
            $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200"
        );
    }
}
