<?php
/*
 * Pipedrive
 *
 * This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
 */

namespace Pipedrive\Tests;

use Pipedrive\APIException;
use Pipedrive\Exceptions;
use Pipedrive\APIHelper;
use Pipedrive\Models;

class TeamsControllerTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var \Pipedrive\Controllers\TeamsController Controller instance
     */
    protected static $controller;

    /**
     * @var HttpCallBackCatcher Callback
     */
    protected $httpResponse;

    /**
     * Setup test class
     */
    public static function setUpBeforeClass()
    {
        $client = new \Pipedrive\Client();
        self::$controller = $client->getTeams();
    }

    /**
     * Setup test
     */
    protected function setUp()
    {
        $this->httpResponse = new HttpCallBackCatcher();
    }

    /**
     * Returns data about teams within the company
     */
    public function testTestGetAllTeams()
    {
        // Parameters for the API call
        $input = array();
        $input['orderBy'] = TestHelper::getJsonMapper()->mapClass(json_decode(
            'id'),
            'Pipedrive\\Models\\string'
        );
        $input['skipUsers'] = null;

        // Set callback and perform API call
        $result = null;
        self::$controller->setHttpCallBack($this->httpResponse);
        try {
            $result = self::$controller->getAllTeams($input);
        } catch (APIException $e) {
        }

        // Test response code
        $this->assertEquals(
            200,
            $this->httpResponse->getResponse()->getStatusCode(),
            "Status is not 200"
        );

        // Test headers
        $headers = [];
        $headers['Content-Type'] = 'application/json' ;

        $this->assertTrue(
            TestHelper::areHeadersProperSubsetOf($headers, $this->httpResponse->getResponse()->getHeaders(), true),
            "Headers do not match"
        );

        // Test whether the captured response is as we expected
        $this->assertNotNull($result, "Result does not exist");

        $this->assertTrue(
            TestHelper::isJsonObjectProperSubsetOf(
                "{\"success\":true,\"data\":[{\"id\":1,\"name\":\"Closers\",\"description\":\"Berlin office Sales Tea" .
                "m\",\"manager_id\":4,\"users\":[2,3,4,5],\"active_flag\":1,\"deleted_flag\":0,\"add_time\":\"2019-10" .
                "-07 09:06:09\",\"created_by_user_id\":2},{\"id\":2,\"name\":\"Coffee\",\"description\":\"London offi" .
                "ce Sales Team\",\"manager_id\":7,\"users\":[5,8],\"active_flag\":0,\"deleted_flag\":0,\"add_time\":" .
                "\"2018-04-11 12:54:43\",\"created_by_user_id\":7}]}",
                $this->httpResponse->getResponse()->getRawBody(),
                false,
                true,
                false
            ),
            "Response body does not match in keys"
        );
    }
}
